<?php
require_once 'functions.php';   // a korábban definiált függvények

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $msg = handleLogin();               // szöveges üzenet (siker vagy hiba)
    $success = (strpos($msg, 'Sikeres bejelentkezés') !== false);

    // JSON objektum, amit a JS fog felhasználni
    echo json_encode([
        'success' => $success,
        'message' => $msg,
        // opcionálisan: a szín, ha sikeres a bejelentkezés
        'color'   => $success ? extractColor($msg) : null
    ]);
    exit;
}

/* -----------------------------------------------------------------
   Segédfüggvény a szín kinyerésére a renderResult() által visszaadott
   szövegből (csak a példához). Ha a renderResult() már csak a színt
   adja vissza, akkor ezt a függvényt elhagyhatod.
   ----------------------------------------------------------------- */
function extractColor(string $msg): ?string
{
    if (preg_match('/kedvenc színed:\s*<strong>([^<]+)<\/strong>/i', $msg, $m)) {
        return $m[1];
    }
    return null;
}
?>
<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <title>Bejelentkezés</title>
    <style>
        /* nagyon egyszerű modal, csak a demonstrációhoz */
        .modal {
            display:none;
            position:fixed;
            top:0; left:0; right:0; bottom:0;
            background:rgba(0,0,0,0.5);
            align-items:center;
            justify-content:center;
        }
        .modal-content{
            background:#fff;
            padding:1.5rem;
            border-radius:5px;
            max-width:90%;
            text-align:center;
        }
    </style>
</head>
<body>
    <h2>Bejelentkezés</h2>
    <form id="loginForm">
        <label>
            E‑mail:
            <input type="email" name="username" required>
        </label><br><br>
        <label>
            Jelszó:
            <input type="password" name="password" required>
        </label><br><br>
        <button type="submit">Belépés</button>
    </form>

    <!-- Modal -->
    <div id="msgModal" class="modal">
        <div class="modal-content" id="modalBody"></div>
    </div>

    <script type="module" src="/scripts/app.module.js"></script>
</body>
</html>

