const form = document.getElementById("loginForm");
const modal = document.getElementById("msgModal");
const modalBody = document.getElementById("modalBody");

function showModal(text, bgColor = null) {
	modalBody.innerHTML = text;
	if (bgColor) {
		modalBody.style.backgroundColor = bgColor;
		modalBody.style.color = "#fff";
	} else {
		modalBody.style.backgroundColor = "";
		modalBody.style.color = "";
	}
	modal.style.display = "flex";
}

// modal bezárása kattintásra
modal.addEventListener("click", () => {
	modal.style.display = "none";
});

form.addEventListener("submit", async (e) => {
	e.preventDefault();

	const formData = new FormData(form);
	const resp = await fetch("", {
		// ugyanaz a PHP‑fájl
		method: "POST",
		body: formData,
	});

	const data = await resp.json();

	// ha hibás jelszó, a PHP már beállította a 3 s átirányítást,
	// de a modalban is jelezzük
	showModal(data.message, data.success ? data.color : null);
});
