class CakeLogger {
  constructor() {
    this.info = this.info.bind(this);
    this.warn = this.warn.bind(this);
    this.error = this.error.bind(this);
    this.debug = this.debug.bind(this);
  }

  public log(type: string, message: any, ...optionalParams: any[]): void {
    // date formatted to "MM-DD_HH:MM:SS"
    const date = new Date().toLocaleString("en-US", {
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
    });
    console.log(`[${type}]`, `[${date}]`, message, ...optionalParams);
  }

  public info(message: string, ...data: any[]): void {
    this.log("INFO", message, ...data);
  }

  public warn(message: string, ...data: any[]): void {
    this.log("WARN", message, ...data);
  }

  public error(message: string, ...data: any[]): void {
    this.log("ERROR", message, ...data);
  }

  public debug(message: string, ...data: any[]): void {
    if (Bun.env.DEBUG) {
      this.log("DEBUG", message, ...data);
    }
  }
}

export default CakeLogger;
