import type { ImageSize } from "../util/music/Scrobbler";

export type LFMArtistResponse = {
	artist: {
		name: string;
		url: string;
		image: {
			"#text": string;
			size: ImageSize;
		}[];
		stats: {
			listeners: string;
			playcount: string;
			userplaycount?: string;
		};
		similar: {
			artist: {
				name: string;
				url: string;
				image: {
					"#text": string;
					size: ImageSize;
				}[];
			}[];
		};
		tags: {
			tag: {
				name: string;
				url: string;
			}[];
		};
		bio: {
			summary: string;
			content: string;
		};
	};
};

export type LFMTopAlbumsResponse = {
	topalbums: {
		album: {
			name: string;
			playcount: string;
			url: string;
			images: LFMArtistResponse["artist"]["image"];
			"@attr": {
				rank: string;
			};
		}[];
		"@attr": {
			page: string;
			perPage: string;
			totalPages: string;
			total: string;
		};
	};
};

export type LFMTopTracksResponse = {
	toptracks: {
		track: {
			name: string;
			playcount: string;
			listeners: string;
			url: string;
			images: LFMArtistResponse["artist"]["image"];
			artist: {
				name: string;
				url: string;
			};
			"@attr": {
				rank: string;
			};
		}[];
		"@attr": {
			page: string;
			perPage: string;
			totalPages: string;
			total: string;
		};
	};
};

export type LFMAlbumResponse = {
	album: {
		name: string;
		playcount: string;
		userplaycount?: string;
		listeners: string;
		artist: string;
		url: string;
		tags: LFMArtistResponse["artist"]["tags"];
		images: LFMArtistResponse["artist"]["image"];
		tracks: {
			track: {
				name: string;
				duration: number;
				url: string;
				artist: {
					name: string;
					url: string;
				};
				"@attr": {
					rank: string;
				};
			}[];
		};
		bio: {
			summary: string;
			content: string;
		};
	};
};

export type LFMTrackResponse = {
	track: {
		name: string;
		url: string;
		duration: string;
		listeners: string;
		playcount: string;
		artist: {
			name: string;
			url: string;
		};
		album: {
			title: string;
			artist: string;
			url: string;
			image: LFMArtistResponse["artist"]["image"];
		};
		toptags: LFMArtistResponse["artist"]["tags"];
		wiki: {
			summary: string;
			content: string;
		};
		userplaycount?: string;
	};
};

export type LFMUserResponse = {
	user: {
		name: string;
		realname: string;
		playcount: string;
		artist_count: string;
		track_count: string;
		album_count: string;
		image: LFMArtistResponse["artist"]["image"];
		registered: {
			unixtime: string;
			"#text": number;
		};
		country: string;
		url: string;
		type: string;
	};
};

export type LFMUserRecentResponse = {
	recenttracks: {
		track: {
			artist: { "#text": string };
			image: LFMArtistResponse["artist"]["image"];
			album: { "#text": string };
			name: string;
			url: string;
			"@attr"?: { nowplaying: string };
		}[];
	};
};
