import {
	type InteractionResponse,
	MessageFlags,
	SlashCommandBuilder,
} from "discord.js";
import CakeCommand, { checkUser } from "../../util/CakeCommand";
import type CakeChatInputCommandInteraction from "../../util/CakeChatInputCommandInteraction";
import { MediaTypes } from "../../util/CakeAL";
import ALMediaEmbed from "../../util/embeds/anilist/search/media";
import type { SearchMediaResponse } from "../../util/anilist/Search";

class AniListSearchCommand extends CakeCommand {
	constructor() {
		super();
		const builder = new SlashCommandBuilder()
			.setName("alsearch")
			.setDescription("Search the list of Ani or sumn");
		builder.addStringOption((o) =>
			o
				.setName("query")
				.setDescription("Err... What was the name again?")
				.setRequired(true),
		);
		builder.addStringOption((o) =>
			o
				.setName("type")
				.setDescription("What are you searching for?")
				.setRequired(true)
				.setChoices([
					{ name: "Media", value: MediaTypes.MEDIA },
					{ name: "Staff", value: MediaTypes.STAFF },
					{ name: "Studio", value: MediaTypes.STUDIO },
					{ name: "User", value: MediaTypes.USER },
				]),
		);
		builder.addBooleanOption((o) =>
			o
				.setName("hype")
				.setDescription("hype this shit up for gang")
				.setRequired(false),
		);
		builder.addBooleanOption((o) =>
			o
				.setName("send")
				.setDescription("Send it to everyone? (defaults to true)")
				.setRequired(false),
		);
		this.data = builder;
	}

	async execute(interaction: CakeChatInputCommandInteraction) {
		if (checkUser(interaction)) return;

		const send = interaction.options.getBoolean("send", false) || true;
		const hype = interaction.options.getBoolean("hype", false) || false;
		const query = interaction.options.getString("query", true);
		const type = interaction.options.getString("type", true) as MediaTypes;

		let reply: InteractionResponse;
		if (send) reply = await interaction.deferReply();
		else
			reply = await interaction.deferReply({
				flags: MessageFlags.Ephemeral,
			});

		const searchResult = await interaction.client.anilist.search(query, type);
		switch (type) {
			case "MEDIA": {
				const embed = ALMediaEmbed(
					hype,
					(searchResult as SearchMediaResponse).media[0],
					`als|${interaction.id}|${reply.id}|${hype}|${type}`,
					(searchResult as SearchMediaResponse).media
						.splice(0, 10)
						.map((media) => {
							return {
								label: `${media.title.english || media.title.romaji || "unknown title"} [${media.format || "unknown format"}]`,
								value: `als|${interaction.id}|${reply.id}|${media.id}`,
							};
						}),
				);
				reply.edit({
					components: [embed],
					flags: MessageFlags.IsComponentsV2,
				});
				break;
			}

			default: {
				reply.edit("not yet implemented sorgy");
			}
		}
	}
}

export default new AniListSearchCommand();
