import {
	type InteractionResponse,
	MessageFlags,
	SlashCommandBuilder,
} from "discord.js";
import CakeCommand, { checkUser } from "../../util/CakeCommand";
import type CakeChatInputCommandInteraction from "../../util/CakeChatInputCommandInteraction";
import ALRecentEmbed from "../../util/embeds/anilist/recent";

class AniListRecentCommand extends CakeCommand {
	constructor() {
		super();
		const builder = new SlashCommandBuilder()
			.setName("alrecent")
			.setDescription("What have you been up to?");
		builder.addBooleanOption((o) =>
			o
				.setName("send")
				.setDescription("Send it to everyone? (defaults to true)")
				.setRequired(false),
		);
		builder.addNumberOption((o) =>
			o
				.setName("limit")
				.setDescription("Max number of activities")
				.setRequired(false),
		);
		this.data = builder;
	}

	async execute(interaction: CakeChatInputCommandInteraction) {
		if (checkUser(interaction)) return;

		const send = interaction.options.getBoolean("send", false) || true;
		const limit = interaction.options.getNumber("limit", false) || 5;

		let reply: InteractionResponse;
		if (send) reply = await interaction.deferReply();
		else
			reply = await interaction.deferReply({
				flags: MessageFlags.Ephemeral,
			});

		const recents = await interaction.client.anilist.getUserRecentsById(
			115130,
			limit,
		);
		const me = await interaction.client.anilist.getUser(115130);
		const embed = ALRecentEmbed(recents, me);
		if (limit > 6) {
			reply.edit({ content: "Dumbass, lower the limit pls (max 6)" });
		}
		reply.edit({
			components: [embed],
			flags: MessageFlags.IsComponentsV2,
		});
	}
}

export default new AniListRecentCommand();
