import {
	ContainerBuilder,
	SectionBuilder,
	TextDisplayBuilder,
	ThumbnailBuilder,
} from "discord.js";
import type { User } from "../../music/Scrobbler";
import type LastFM from "../../music/LastFMMapper";
import config from "../../../../config.json";

export default async function NowPlayingEmbed(lfmClient: LastFM, user: User) {
	const container = new ContainerBuilder();
	const mainSection = new SectionBuilder();
	const footerSection = new TextDisplayBuilder();

	mainSection.addTextDisplayComponents(
		new TextDisplayBuilder({ content: `-# _check this shit out gang_` }),
		new TextDisplayBuilder({ content: `da cake is listening to:` }),
	);

	if (user.recent[0].current) {
		const song = user.recent[0];
		const songData = await lfmClient.getTrack(song.artist.name, song.name);
		const scrobbleData = await lfmClient.getTrackScrobbles(
			config.lastfm.username,
			song.artist.name,
			song.name,
		);

		mainSection.addTextDisplayComponents(
			new TextDisplayBuilder({
				content: `# [${song.artist.name} - ${song.name}](${song.url})`,
			}),
		);

		footerSection.setContent(`-# i have listened like uhh ${scrobbleData.count} times`);

		mainSection.setThumbnailAccessory(
			new ThumbnailBuilder({
				media: {
					url:
						songData.album.images[songData.album.images.length - 1].url ||
						"https://i.imgur.com/JQI9gyB.png",
				},
			}),
		);
	} else {
		mainSection.addTextDisplayComponents(
			new TextDisplayBuilder({
				content: `# nothing.`,
			}),
		);
		mainSection.setThumbnailAccessory(
			new ThumbnailBuilder({
				media: {
					url: user.avatar || "https://i.imgur.com/JQI9gyB.png",
				},
			}),
		);
	}

	container.addSectionComponents(mainSection);
	container.addTextDisplayComponents(footerSection);

	return container;
}
