import {
	ActionRowBuilder,
	ComponentType,
	ContainerBuilder,
	MediaGalleryBuilder,
	SectionBuilder,
	SeparatorBuilder,
	StringSelectMenuBuilder,
	TextDisplayBuilder,
} from "discord.js";
import type { SearchMediaResponse } from "../../../anilist/Search";
import type { GetMediaResponse } from "../../../anilist/Get";

function trl(items: string[]) {
	if (!Array.isArray(items) || items.length === 0) return "";
	if (items.length === 1) return String(items[0]);

	const allButLast = items.slice(0, -1).join(", ");
	const last = items[items.length - 1];
	return `${allButLast} and ${last}`;
}

export default function ALMediaEmbed(
	hype: boolean,
	media: SearchMediaResponse["media"][0] | GetMediaResponse["Media"],
	id: string,
	others: { label: string; value: string }[],
) {
	const container = new ContainerBuilder();
	container.addTextDisplayComponents({
		content: hype ? `-# _yall should check this out fr_` : `-# _hiiii :3_`,
		type: ComponentType.TextDisplay,
	});

	if (media.bannerImage) {
		container.addMediaGalleryComponents(
			new MediaGalleryBuilder({
				items: [
					{
						media: {
							url: media.bannerImage || "https://i.imgur.com/NKKiaf4.png",
						},
					},
				],
			}),
		);
	}

	// media section ----------------
	const description = media.description
		?.replace(/(<br ?\/?>)/gi, "\n")
		.replaceAll("\n\n", "\n");
	const mainMediaSection = new SectionBuilder({
		components: [
			{
				content:
					media.title.english || media.title.romaji
						? `# [${media.title.english || media.title.romaji}](${media.siteUrl})`
						: `# [Unknown title (lol how)](${media.siteUrl})`,
				type: ComponentType.TextDisplay,
			},
			{
				content: description || "*No description.*",
				type: ComponentType.TextDisplay,
			},
		],
		accessory: {
			type: ComponentType.Thumbnail,
			media: {
				url: media.coverImage.extraLarge || "https://i.imgur.com/JQI9gyB.png",
			},
		},
	});
	container.addSectionComponents(mainMediaSection);
	container.addSeparatorComponents(new SeparatorBuilder());

	const details = [];

	const types = {
		MANGA: "mango",
		ANIME: "animu",
		TV: "animu",
		NOVEL: "lighto noveru",
		U: "...idfk what it is..",
	};

	details.push(`its a ${types[(media.format as keyof typeof types) || "U"]}.`);
	if (media.chapters)
		details.push(`it is finished. it got \`${media.chapters}\` chapters.`);
	if (media.episodes && !media.endDate)
		details.push(
			`it aint finished. it got \`${media.episodes}\` episodes out tho!`,
		);
	if (media.episodes && media.endDate)
		details.push(`it is finished. it got \`${media.episodes}\` episodes.`);
	if (media.averageScore)
		details.push(`da average ratin is ${media.averageScore / 10}.`);
	if (media.genres && media.genres.length > 0)
		details.push(`da genres are: ${trl(media.genres.map((g) => `\`${g}\``))}.`);

	let tags = "no tags on dis one boys (how)";
	if (media.tags && media.tags.length > 0)
		tags = trl(
			media.tags.splice(0, 8).map((t) => {
				return `\`${t.name} [${t.rank}%]\``;
			}),
		);

	container.addTextDisplayComponents(
		// episodes/chapters // start/end date // avg rating // favorites
		new TextDisplayBuilder({ content: "## da deets" }),
		new TextDisplayBuilder({ content: details.join(" ") }),
		// tags
		new TextDisplayBuilder({ content: "## da tags" }),
		new TextDisplayBuilder({
			content: `-# ${tags}`,
		}),
	);
	// ------------------------------

	const selectorSection = new StringSelectMenuBuilder({
		customId: id,
		options: [...others],
		placeholder: "select anotha one :3",
	});
	const actionRow = new ActionRowBuilder<StringSelectMenuBuilder>({
		components: [selectorSection],
	});
	container.addActionRowComponents(actionRow);

	container.addTextDisplayComponents({
		type: ComponentType.TextDisplay,
		content: hype ? "-# _but fr check it out_" : "-# _uwu_",
	});

	return container;
}
