import {
  Routes,
  type APIApplicationCommand,
  type RESTPostAPIChatInputApplicationCommandsJSONBody,
  type RESTPostAPIContextMenuApplicationCommandsJSONBody,
} from "discord.js";
import config from "../../config.json";
import type { CakeClient } from "./CakeClient";

async function deployCommands(client: CakeClient) {
  const cakeCommands = client.commands;
  const commands: (
    | RESTPostAPIChatInputApplicationCommandsJSONBody
    | RESTPostAPIContextMenuApplicationCommandsJSONBody
  )[] = [];

  for (const command of cakeCommands.values()) {
    const data = command.data.toJSON();
    data.contexts = [0, 1, 2];
    commands.push(data);
  }

  try {
    client.logger.info(
      `Started refreshing ${commands.length} application (/) commands.`
    );

    const data = (await client.rest.put(
      Routes.applicationCommands(config.discord.clientId),
      { body: commands }
    )) as APIApplicationCommand[];

    client.logger.info("Successfully reloaded application (/) commands.");
  } catch {
    client.logger.error(
      "An error occurred while refreshing application (/) commands."
    );
  }
}

export default deployCommands;
