// TypeScript types for the SearchMedia query
export interface SearchMediaVariables {
	search?: string;
}

export interface SearchMediaResponse {
	media: {
		id: number;
		title: {
			romaji: string;
			english: string;
		};
		description?: string | null;
		volumes?: number | null;
		chapters?: number | null;
		episodes?: number | null;
		averageScore?: number | null;
		bannerImage?: string | null;
		tags: {
			id: number;
			name: string;
			rank: number;
		}[];
		coverImage: {
			extraLarge: string;
			color?: string | null;
		};
		endDate?: {
			day?: number | null;
			month?: number | null;
			year?: number | null;
		} | null;
		startDate?: {
			day?: number | null;
			month?: number | null;
			year?: number | null;
		} | null;
		status?: string | null;
		externalLinks?:
			| {
					site: string;
					url: string;
					type?: string | null;
			  }[]
			| null;
		popularity?: number | null;
		rankings?:
			| {
					rank: number;
					allTime?: boolean | null;
					context: string;
					format?: string | null;
					season?: string | null;
					type?: string | null;
					year: number;
			  }[]
			| null;
		format?: string | null;
		studios?: {
			edges?:
				| {
						isMain?: boolean | null;
						node: {
							name: string;
						};
				  }[]
				| null;
		} | null;
		season?: string | null;
		seasonYear?: number | null;
		genres?: string[] | null;
		siteUrl: string;
	}[];
}

export interface SearchUserVariables {
	search?: string;
}

export interface SearchUserResponse {
	users: {
		id: number;
		name: string;
	}[];
}

export interface SearchStaffVariables {
	search?: string;
}

export interface SearchStaffResponse {
	staff: {
		id: number;
		name: {
			full: string;
		};
		favourites: number;
		description: string;
		image: {
			large: string;
		};
		staffMedia: {
			pageInfo: {
				total: number;
			};
		};
		siteUrl: string;
	}[];
}

export interface SearchStudioVariables {
	search?: string;
}

export interface SearchStudioResponse {
	studios: {
		id: number;
		name: string;
		siteUrl: string;
		favourites: number;
		media: {
			pageInfo: {
				total: number;
			};
		};
	}[];
}
