// TypeScript types for the GetMedia query
export interface GetMediaVariables {
	id?: number;
}

export interface GetMediaResponse {
	Media: {
		id: number;
		title: {
			romaji: string;
			english: string;
		};
		description?: string | null;
		volumes?: number | null;
		chapters?: number | null;
		episodes?: number | null;
		averageScore?: number | null;
		bannerImage: string | null;
		tags: {
			id: number;
			name: string;
			rank: number;
		}[];
		coverImage: {
			extraLarge: string;
			color?: string | null;
		};
		endDate?: {
			day?: number | null;
			month?: number | null;
			year?: number | null;
		} | null;
		startDate?: {
			day?: number | null;
			month?: number | null;
			year?: number | null;
		} | null;
		status?: string | null;
		externalLinks?:
			| {
					site: string;
					url: string;
					type?: string | null;
			  }[]
			| null;
		popularity?: number | null;
		rankings?:
			| {
					rank: number;
					allTime?: boolean | null;
					context: string;
					format?: string | null;
					season?: string | null;
					type?: string | null;
					year: number;
			  }[]
			| null;
		format?: string | null;
		studios?: {
			edges?:
				| {
						isMain?: boolean | null;
						node: {
							name: string;
						};
				  }[]
				| null;
		} | null;
		season?: string | null;
		seasonYear?: number | null;
		genres?: string[] | null;
		siteUrl: string;
	};
}

// TypeScript types for the GetUser query
export interface GetUserVariables {
	id?: number;
}

export interface GetUserResponse {
	User: {
		id: number;
		name: string;
		avatar: {
			large: string;
		};
		bannerImage?: string | null;
		createdAt?: number | null;
		statistics?: {
			anime?: {
				count?: number | null;
				episodesWatched?: number | null;
				meanScore?: number | null;
			} | null;
			manga?: {
				chaptersRead?: number | null;
				count?: number | null;
				meanScore?: number | null;
			} | null;
		} | null;
		siteUrl: string;
		options: {
			profileColor:
				| "blue"
				| "purple"
				| "pink"
				| "orange"
				| "red"
				| "green"
				| "gray"
				| `#${string}`;
		};
	} | null;
}

export interface GetStaffVariables {
	id?: number;
}

export interface GetStaffResponse {
	Staff: {
		id: number;
		name: {
			full: string;
		};
		favourites: number;
		description: string;
		image: {
			large: string;
		};
		staffMedia: {
			edges: {
				node: {
					id: number;
					title: {
						romaji: string;
						english: string;
					};
					favourites: number;
					siteUrl: string;
				};
				staffRole: string;
			}[];
		};
		siteUrl: string;
	} | null;
}

export interface GetStudioVariables {
	id?: number;
}

export interface GetStudioResponse {
	Studio: {
		id: number;
		name: string;
		siteUrl: string;
		favourites: number;
		media: {
			edges: {
				node: {
					id: number;
					title: {
						romaji: string;
						english: string;
					};
					favourites: number;
					siteUrl: string;
				};
				isMainStudio: boolean;
			}[];
		};
	} | null;
}

export interface GetUserRecentsResponse {
	Page: {
		activities: {
			id: string;
			siteUrl: string;
			status: string;
			progress: string | null;
			media: {
				id: number;
				title: {
					userPreferred: string;
				};
				siteUrl: string;
				format: string;
				coverImage: {
					color: string | null;
					extraLarge: string;
				};
				description: string;
				episodes: number | null;
				chapters: number | null;
			};
		}[];
	};
}
