import {
	type InteractionResponse,
	MessageFlags,
	SlashCommandBuilder,
} from "discord.js";
import CakeCommand, { checkUser } from "../../util/CakeCommand";
import type CakeChatInputCommandInteraction from "../../util/CakeChatInputCommandInteraction";
import NowPlayingEmbed from "../../util/embeds/music/nowPlaying";

class NowPlayingCommand extends CakeCommand {
	constructor() {
		super();
		const builder = new SlashCommandBuilder()
			.setName("np")
			.setDescription("Send your currently playing song!");
		builder.addBooleanOption((o) =>
			o
				.setName("send")
				.setDescription("Send it to everyone? (defaults to true)")
				.setRequired(false),
		);
		this.data = builder;
	}

	async execute(interaction: CakeChatInputCommandInteraction) {
		if (checkUser(interaction)) return;

		const send = interaction.options.getBoolean("send", false) || true;
		let reply: InteractionResponse;
		if (send) reply = await interaction.deferReply();
		else
			reply = await interaction.deferReply({
				flags: MessageFlags.Ephemeral,
			});

		const me = await interaction.client.lastfm.getUser("Kex1016");
		reply.edit({
			components: [await NowPlayingEmbed(interaction.client.lastfm, me)],
			flags: MessageFlags.IsComponentsV2,
		});
	}
}

export default new NowPlayingCommand();
