import {
	ComponentType,
	ContainerBuilder,
	SectionBuilder,
	SeparatorBuilder,
	TextDisplayBuilder,
} from "discord.js";
import type {
	GetUserRecentsResponse,
	GetUserResponse,
} from "../../anilist/Get";

function cfl(str: string) {
	if (!str) return "";
	return str[0].toUpperCase() + str.slice(1);
}

export default function ALRecentEmbed(
	recents: GetUserRecentsResponse,
	user: GetUserResponse,
) {
	const container = new ContainerBuilder();
	const footerSection = new TextDisplayBuilder();

	container.addTextDisplayComponents(
		{
			content: `-# _check this shit out gang_`,
			type: ComponentType.TextDisplay,
		},
		{
			content:
				recents.Page.activities.length === 0
					? "my anilist is literally empty wtf?!"
					: "da cake has been up to sumn nefarious:",
			type: ComponentType.TextDisplay,
		},
	);

	for (let i = 0; i < recents.Page.activities.length; i++) {
		const media = recents.Page.activities[i];
		const types = {
			MANGA: "mango",
			ANIME: "animu",
			TV: "animu",
			NOVEL: "lighto noveru",
			U: "...idfk what it is..",
		};

		let episodeText = "";
		if (!media.media.chapters && !media.media.episodes) episodeText = "ongoing";
		else
			episodeText = `${media.media.episodes || media.media.chapters} ${media.media.episodes ? "episodes" : "chapters"}`;

		const mediaSection = new SectionBuilder({
			components: [
				{
					content: `### **${cfl(media.status)}${media.progress ? ` ${media.progress} of` : ""}**`,
					type: ComponentType.TextDisplay,
				},
				{
					content: `[${media.media.title.userPreferred}](${media.media.siteUrl})`,
					type: ComponentType.TextDisplay,
				},
				{
					content: `-# ${types[media.media.format as keyof typeof types]}, ${episodeText}`,
					type: ComponentType.TextDisplay,
				},
			],
			accessory: {
				media: {
					url:
						media.media.coverImage.extraLarge ||
						"https://i.imgur.com/JQI9gyB.png",
				},
				type: ComponentType.Thumbnail,
			},
		});

		container.addSectionComponents(mediaSection);

		if (i < recents.Page.activities.length - 1) {
			container.addSeparatorComponents(new SeparatorBuilder());
		}
	}

	footerSection.setContent(
		`-# da cake watched like ${user.User?.statistics?.anime?.count || 0} anime and read uhh ${user.User?.statistics?.manga?.chaptersRead || 0} chapters`,
	);

	container.addTextDisplayComponents(footerSection);
	return container;
}
