import {
	type ContextMenuCommandBuilder,
	MessageFlags,
	SlashCommandBuilder,
} from "discord.js";
import type CakeAutocompleteInteraction from "./CakeAutocompleteInteraction";
import type CakeChatInputCommandInteraction from "./CakeChatInputCommandInteraction";
import config from "../../config.json";

export function checkUser(interaction: CakeChatInputCommandInteraction) {
	if (interaction.user.id !== config.owner)
		return interaction.reply({
			content: "ur not da ckae hop off",
			flags: MessageFlags.Ephemeral,
		});
	return null;
}

abstract class CakeCommand {
	autocomplete?(interaction: CakeAutocompleteInteraction): Promise<void>;
	data: SlashCommandBuilder | ContextMenuCommandBuilder;

	constructor() {
		this.data = new SlashCommandBuilder();
	}

	abstract execute(interaction: CakeChatInputCommandInteraction): Promise<void>;
}

export default CakeCommand;
