import {
	type CacheType,
	type Interaction,
	MessageFlags,
	type StringSelectMenuComponent,
} from "discord.js";
import type { CakeClient } from "../../util/CakeClient";
import ALMediaEmbed from "../../util/embeds/anilist/search/media";
import config from "../../../config.json";

export default async function ALSearchInteraction(
	interaction: Interaction<CacheType>,
) {
	if (interaction.user.id !== config.owner) return;
	if (!interaction.isStringSelectMenu()) return;
	if (!interaction.customId) return;
	if (!interaction.customId.startsWith("als")) return;
	if (interaction.values.length !== 1) return;
	if (!interaction.values[0].startsWith("als")) return;

	const container = interaction.message.components.find(
		(row) => row.type === 17,
	);
	if (!container) {
		interaction.reply({
			content: "sorry something went wrogn",
			flags: MessageFlags.Ephemeral,
		});
		return;
	}

	const actionRow = container.components.find((row) => row.type === 1);
	if (!actionRow) {
		interaction.reply({
			content: "sorry something went wrogn",
			flags: MessageFlags.Ephemeral,
		});
		return;
	}

	const selectMenu = actionRow.components.find(
		(comp) => comp.type === 3 && comp.customId === interaction.customId,
	) as StringSelectMenuComponent;
	if (!selectMenu) {
		interaction.reply({
			content: "sorry something went wrogn",
			flags: MessageFlags.Ephemeral,
		});
		return;
	}

	const [, , , hype, type] = interaction.customId.split("|");

	const og_options = selectMenu.options;
	// als|1445158702071025704|1445158702071025704|87031
	const [, , , mediaId] = interaction.values[0].split("|");
	const media = await (interaction.client as CakeClient).anilist.getMedia(
		mediaId,
	);
	if (!media || !media.Media) {
		interaction.reply({
			content: "sorry something went wrogn",
			flags: MessageFlags.Ephemeral,
		});
		return;
	}

	const embed = ALMediaEmbed(
		hype === "1",
		media.Media,
		interaction.customId,
		og_options,
	);
	interaction.update({
		components: [embed],
	});
}
