import config from "../config.json";
import { Events, GatewayIntentBits } from "discord.js";
import ReadyEvent from "./events/ready";
import { CakeClient } from "./util/CakeClient";
import ALSearchInteraction from "./events/anilist/searchInteraction";

const client = new CakeClient({
	intents: [
		GatewayIntentBits.DirectMessages,
		GatewayIntentBits.Guilds,
		GatewayIntentBits.MessageContent,
	],
});

client.on(Events.ClientReady, (client) => ReadyEvent(client as CakeClient));
client.on(Events.InteractionCreate, async (interaction) => await ALSearchInteraction(interaction))

await client.login(config.discord.token);
